<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class ProductModel extends Model 
{

    protected $table = 'product';
    public $timestamps = true;
    protected $fillable = array('product_name', 'category_id', 'brand_id', 'width', 'height', 'description', 'product_price', 'quantity', 'url', 'status');
    protected $visible = array('product_name', 'category_id', 'brand_id', 'width', 'height', 'description', 'product_price', 'quantity', 'url', 'status');

    public function Categoryof()
    {
        return $this->belongsTo('CategoryModel');
    }

    public function Brandof()
    {
        return $this->belongsTo('BrandModel');
    }

    public function orderDetails()
    {
        return $this->hasMany('OrderDetailsModel');
    }

    public function images()
    {
        return $this->hasMany('ImgesModel', 'product_id');
    }

    public function cart()
    {
        return $this->belongsToMany('Cartmodel', 'cart_id');
    }

}